<?php
// app/views/partials/member_sidebar.php
$current = $_GET['page'] ?? 'dashboard';

// supaya aman kalau dipanggil 2x (desktop + offcanvas)
if (!function_exists('active_member')) {
  function active_member($p, $cur) {
    return $p === $cur ? 'active' : '';
  }
}

$BASE = '/jwdnetwork/member.php?page=';
?>
<div class="sidebar-inner">
  <div class="sidebar-brand">
    <div class="brand-dot"></div>
    <div>
      <div class="fw-bold">JWD NETWORK</div>
      <div class="small text-white-50">Member</div>
    </div>
  </div>

  <div class="sidebar-user">
    <div class="avatar">
      <i class="bi bi-person-fill"></i>
    </div>
    <div class="min-w-0">
      <div class="fw-semibold text-truncate"><?= e($_SESSION['auth']['username'] ?? 'member') ?></div>
      <div class="small text-white-50">ID: <?= (int)($_SESSION['auth']['id'] ?? 0) ?></div>
    </div>
  </div>

  <div class="sidebar-menu">
    <a class="menu-item <?= active_member('dashboard',$current) ?>" href="<?= $BASE ?>dashboard">
      <i class="bi bi-speedometer2 me-2"></i> Dashboard
    </a>

    <a class="menu-item <?= active_member('profile',$current) ?>" href="<?= $BASE ?>profile">
      <i class="bi bi-person-circle me-2"></i> Profile
    </a>

    <a class="menu-item <?= active_member('sponsor',$current) ?>" href="<?= $BASE ?>sponsor">
      <i class="bi bi-people me-2"></i> Sponsor Langsung
    </a>

    <a class="menu-item <?= active_member('change_password',$current) ?>" href="<?= $BASE ?>change_password">
      <i class="bi bi-shield-lock me-2"></i> Ganti Password
    </a>

    <a class="menu-item <?= active_member('withdraw',$current) ?>" href="<?= $BASE ?>withdraw">
      <i class="bi bi-cash-coin me-2"></i> Withdraw
    </a>

    <a class="menu-item <?= active_member('reward',$current) ?>" href="<?= $BASE ?>reward">
      <i class="bi bi-award me-2"></i> Reward
    </a>

    <a class="menu-item <?= active_member('network',$current) ?>" href="<?= $BASE ?>network">
      <i class="bi bi-diagram-3 me-2"></i> Network
    </a>

    <a class="menu-item <?= active_member('pins',$current) ?>" href="<?= $BASE ?>pins">
      <i class="bi bi-upc-scan me-2"></i> PIN Saya
    </a>

    <a class="menu-item <?= active_member('register',$current) ?>" href="<?= $BASE ?>register">
      <i class="bi bi-person-plus me-2"></i> Register Downline
    </a>

    <a class="menu-item <?= active_member('wallet',$current) ?>" href="<?= $BASE ?>wallet">
      <i class="bi bi-wallet2 me-2"></i> Wallet
    </a>

    <a class="menu-item <?= active_member('reports',$current) ?>" href="<?= $BASE ?>reports">
      <i class="bi bi-receipt me-2"></i> Reports
    </a>

    <div class="menu-divider"></div>

    <a class="menu-item text-danger" href="/jwdnetwork/public/?r=logout">
      <i class="bi bi-box-arrow-right me-2"></i> Logout
    </a>
  </div>
</div>
